<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('client_id', 'name', 'email', 'user_name', 'pin', 'profile_pic', 'security_question_id', 'security_question_answer', 'role_id');

	public function security_questions()
	{
		return $this->hasOne('App\Models\SecurityQuestion', 'security_question_id');
	}

	public function clients()
	{
		return $this->hasOne('App\Models\Client', 'client_id');
	}

	public function ip_white_list()
	{
		return $this->hasMany('App\Models\IpWhiteList', 'user_id');
	}

	public function roles()
	{
		return $this->hasOne('App\Models\Role', 'role_id');
	}

	public function operators()
	{
		return $this->hasOne('App\Models\User', 'user_id');
	}

	public function players()
	{
		return $this->hasOne('App\Models\Player', 'user_id');
	}

	public function rejection_notes()
	{
		return $this->hasMany('App\Models\RejectionNote', 'user_id');
	}

	public function blogs()
	{
		return $this->hasMany('App\Models\Blog', 'added_by');
	}

}