<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoryTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('category_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('category_id')->unsigned();
			$table->string('locale', 100)->index();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('category_translations');
	}
}