<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitsTable extends Migration {

	public function up()
	{
		Schema::create('visits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('added_by_id')->unsigned()->nullable();
			$table->integer('branch_id')->unsigned()->nullable();
			$table->date('date');
			$table->string('time', 255);
			$table->string('code');
			$table->string('mobile');
			$table->string('year');
			$table->string('status', 100)->default('hold');
			$table->string('month', 100);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('visits');
	}
}