<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->date('date');
			$table->float('total');
			$table->decimal('hours_count');
			$table->string('status')->default('hold');
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}