<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmpVacationsTable extends Migration {

	public function up()
	{
		Schema::create('emp_vacations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('added_by_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('branch_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('days_count');
			$table->string('type')->default('not-paid');
			$table->string('status')->default('hold');
			$table->string('hr_status')->default('hold');
			$table->string('team_leader_status')->default('hold');
		});
	}

	public function down()
	{
		Schema::drop('emp_vacations');
	}
}