<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PLANS_TABLE extends Eloquent {

	protected $table = 'PLANS';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('plan_title', 'storage_capacity', 'userID', 'planTypeId');

	public function plans()
	{
		return $this->belongsTo('USERS_TABLE');
	}

	public function plans()
	{
		return $this->hasOne('FRAMES_TABLE');
	}

	public function plan()
	{
		return $this->belongsTo('PLAN_TYPE');
	}

}