<?php

class Address extends Eloquent {

	protected $table = 'addresses';
	public $timestamps = true;
	protected $fillable = array('lat', 'lon', 'country_id', 'state_id', 'city_id', 'district', 'street', 'building_number', 'floor_number', 'employee_id', 'user_id', 'seller_id', 'title');
	protected $visible = array('lat', 'lon', 'country_id', 'state_id', 'city_id', 'district', 'street', 'building_number', 'floor_number', 'employee_id', 'user_id', 'seller_id', 'title');

	public function user()
	{
		return $this->belongsTo('Address', 'user_id');
	}

	public function country()
	{
		return $this->hasOne('Country', 'country_id');
	}

	public function state()
	{
		return $this->hasOne('State', 'state_id');
	}

	public function city()
	{
		return $this->hasOne('City', 'city_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function seller()
	{
		return $this->belongsTo('Seller', 'seller_id');
	}

}