<?php

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('title', 'image', 'description', 'major_id');
	protected $visible = array('title', 'image', 'description', 'major_id');

	public function major()
	{
		return $this->belongsTo('Major', 'major_id');
	}

	public function subcategories()
	{
		return $this->hasMany('Subcategory', 'category_id');
	}

}