<?php

class Driver extends Eloquent {

	protected $table = 'drivers';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'mobile', 'password', 'image', 'phone_verify', 'device_token', 'api_token', 'verify_code', 'block', 'block_reason', 'display_block_reason', 'identification_number_image', 'residence_deed_image', 'gender_id', 'qualification', 'birthday', 'alternative_phone', 'armycase_id', 'statussocial_id', 'expiry_date_postponement', 'vehicle_license_image', 'vehicle_license_number', 'country_id', 'state_id', 'city_id', 'wallet_amount');
	protected $visible = array('name', 'phone', 'mobile', 'password', 'image', 'phone_verify', 'device_token', 'api_token', 'verify_code', 'block', 'block_reason', 'display_block_reason', 'identification_number_image', 'residence_deed_image', 'gender_id', 'qualification', 'birthday', 'alternative_phone', 'armycase_id', 'statussocial_id', 'expiry_date_postponement', 'vehicle_license_image', 'vehicle_license_number', 'country_id', 'state_id', 'city_id', 'wallet_amount');

	public function genderType()
	{
		return $this->belongsTo('Gender', 'gender_id');
	}

	public function armyCase()
	{
		return $this->belongsTo('Armycase', 'armycase_id');
	}

	public function statusSocial()
	{
		return $this->belongsTo('Statussocials', 'statussocial_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function state()
	{
		return $this->belongsTo('State', 'state_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

}