<?php

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'mobile', 'password', 'image', 'phone_verify', 'device_id', 'device_token', 'api_token', 'verify_code', 'block', 'block_reason', 'identification_number_image', 'display_block_reason', 'residence_deed_image', 'jobtitle_id', 'gender_id', 'qualification', 'birthday', 'alternative_phone', 'armycase_id', 'expiry_date_postponement', 'statussocial_id', 'wallet_amount');
	protected $visible = array('name', 'phone', 'mobile', 'password', 'image', 'phone_verify', 'device_id', 'device_token', 'api_token', 'verify_code', 'block', 'block_reason', 'identification_number_image', 'display_block_reason', 'residence_deed_image', 'jobtitle_id', 'gender_id', 'qualification', 'birthday', 'alternative_phone', 'armycase_id', 'expiry_date_postponement', 'statussocial_id', 'wallet_amount');

	public function employeecontracts()
	{
		return $this->hasMany('Employeescontract', 'employee_id');
	}

	public function employeesContractsCreating()
	{
		return $this->hasMany('Employeescontract', 'creator_employee_id');
	}

	public function address()
	{
		return $this->hasOne('Address', 'employee_id');
	}

	public function attendances()
	{
		return $this->hasMany('Attendance', 'employee_id');
	}

	public function sellerContracts()
	{
		return $this->hasMany('Sellercontract', 'employee_id');
	}

	public function jobTitle()
	{
		return $this->belongsTo('Jobtitle', 'jobtitle_id');
	}

	public function genderType()
	{
		return $this->belongsTo('Gender', 'gender_id');
	}

	public function armyCase()
	{
		return $this->belongsTo('Armycase', 'armycase_id');
	}

	public function statusSocials()
	{
		return $this->belongsTo('Statussocials', 'statussocial_id');
	}

}