<?php

class Seller extends Eloquent {

	protected $table = 'sellers';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'mobile', 'prepare_time', 'description', 'major_id', 'device_token', 'verify_code', 'api_token', 'password', 'wallet_amount', 'block', 'availability', 'not_available_reason', 'block_reason', 'close');
	protected $visible = array('name', 'phone', 'mobile', 'prepare_time', 'description', 'major_id', 'device_token', 'verify_code', 'api_token', 'password', 'wallet_amount', 'block', 'availability', 'not_available_reason', 'block_reason', 'close');

	public function major()
	{
		return $this->belongsTo('Major', 'major_id');
	}

	public function city()
	{
		return $this->belongsTo('City', 'city_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function state()
	{
		return $this->belongsTo('State', 'state_id');
	}

	public function items()
	{
		return $this->hasMany('Item', 'item_id');
	}

	public function images()
	{
		return $this->hasMany('Sellerimage', 'seller_id');
	}

	public function sellerMessages()
	{
		return $this->hasMany('Sellermessage', 'seller_id');
	}

	public function workschedules()
	{
		return $this->hasMany('Workschedule', 'seller_id');
	}

	public function social()
	{
		return $this->hasOne('Social', 'seller_id');
	}

	public function address()
	{
		return $this->hasOne('Address', 'seller_id');
	}

	public function contracts()
	{
		return $this->hasMany('Sellercontract', 'seller_id');
	}

}