<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Group extends Eloquent {

	protected $table = 'groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function emails()
	{
		return $this->belongsToMany('App\Models\Newletter\Email');
	}

	public function automatisms()
	{
		return $this->belongsToMany('App\Models\Newletter\Automatism');
	}

	public function metagroup()
	{
		return $this->belongsTo('App\Models\Newletter\Metagroup');
	}

}