<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SuppliedNewsletterGroup extends Eloquent {

	protected $table = 'supplied_newsletter_groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function supplied_newsletters()
	{
		return $this->hasMany('App\Models\Newletter\SuppliedNewsletter');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Newletter\Client');
	}

}