<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 30)->unique();
			$table->string('slug', 10)->unique();
			$table->boolean('create')->default(false);
			$table->boolean('modif')->default(false);
			$table->boolean('delete')->default(false);
			$table->boolean('valid_edition')->default(false);
			$table->boolean('user_gestion')->default(false);
			$table->boolean('message_gest')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}