<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('pseudo', 30)->unique();
			$table->integer('role_id')->unsigned()->index();
			$table->string('email', 60)->unique();
			$table->string('password', 60)->unique();
			$table->boolean('seen')->default(false);
			$table->boolean('actif')->default(true);
			$table->string('remember_token', 100)->nullable();
			$table->string('nom', 30)->nullable();
			$table->string('prenom', 30)->nullable();
			$table->string('avatar', 150)->nullable();
			$table->boolean('confirmed')->nullable()->default(false);
			$table->string('confirmed_code', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}