<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 60)->unique();
			$table->string('slug', 30)->unique();
			$table->string('url')->unique();
			$table->smallInteger('width');
			$table->smallInteger('height');
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}