<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->string('slug', 255);
			$table->text('content');
			$table->string('image', 255);
			$table->string('type', 255);
			$table->timestamp('publish_date');
			$table->tinyInteger('active')->default('0');
			$table->timestamps();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}