<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('models', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('type_id')->references('id')->on('types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('visibility_id')->references('id')->on('visibilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_parents', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_parents', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procduct_categories', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('procduct_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->foreign('combination_id')->references('id')->on('combinations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('combinations', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('combinations', function(Blueprint $table) {
			$table->foreign('combinaison_value_id')->references('id')->on('combinaison_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('combinaison_values', function(Blueprint $table) {
			$table->foreign('combinaison_attribute_id')->references('id')->on('combinaison_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('combination_id')->references('id')->on('combinations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('combination_id')->references('id')->on('combinations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_totals', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_totals', function(Blueprint $table) {
			$table->foreign('total_type_id')->references('id')->on('total_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_taxes', function(Blueprint $table) {
			$table->foreign('order_detail_id')->references('id')->on('order_details')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->foreign('tax_address_id')->references('id')->on('tax_addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->foreign('geo_zone_id')->references('id')->on('geo_zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('geo_zone_zones', function(Blueprint $table) {
			$table->foreign('geo_zone_id')->references('id')->on('geo_zones')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('geo_zone_zones', function(Blueprint $table) {
			$table->foreign('zone_id')->references('id')->on('zones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('zones', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('zones', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_groups_taxes', function(Blueprint $table) {
			$table->foreign('tax_group_id')->references('id')->on('tax_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_groups_taxes', function(Blueprint $table) {
			$table->foreign('tax_id')->references('id')->on('taxes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('models', function(Blueprint $table) {
			$table->dropForeign('models_brand_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_type_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_model_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_visibility_id_foreign');
		});
		Schema::table('category_parents', function(Blueprint $table) {
			$table->dropForeign('category_parents_parent_id_foreign');
		});
		Schema::table('category_parents', function(Blueprint $table) {
			$table->dropForeign('category_parents_category_id_foreign');
		});
		Schema::table('procduct_categories', function(Blueprint $table) {
			$table->dropForeign('procduct_categories_product_id_foreign');
		});
		Schema::table('procduct_categories', function(Blueprint $table) {
			$table->dropForeign('procduct_categories_category_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_product_id_foreign');
		});
		Schema::table('images', function(Blueprint $table) {
			$table->dropForeign('images_combination_id_foreign');
		});
		Schema::table('combinations', function(Blueprint $table) {
			$table->dropForeign('combinations_product_id_foreign');
		});
		Schema::table('combinations', function(Blueprint $table) {
			$table->dropForeign('combinations_combinaison_value_id_foreign');
		});
		Schema::table('combinaison_values', function(Blueprint $table) {
			$table->dropForeign('combinaison_values_combinaison_attribute_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_product_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_combination_id_foreign');
		});
		Schema::table('stocks', function(Blueprint $table) {
			$table->dropForeign('stocks_location_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_product_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_combination_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('order_totals', function(Blueprint $table) {
			$table->dropForeign('order_totals_order_id_foreign');
		});
		Schema::table('order_totals', function(Blueprint $table) {
			$table->dropForeign('order_totals_total_type_id_foreign');
		});
		Schema::table('order_taxes', function(Blueprint $table) {
			$table->dropForeign('order_taxes_order_detail_id_foreign');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->dropForeign('taxes_tax_address_id_foreign');
		});
		Schema::table('taxes', function(Blueprint $table) {
			$table->dropForeign('taxes_geo_zone_id_foreign');
		});
		Schema::table('geo_zone_zones', function(Blueprint $table) {
			$table->dropForeign('geo_zone_zones_geo_zone_id_foreign');
		});
		Schema::table('geo_zone_zones', function(Blueprint $table) {
			$table->dropForeign('geo_zone_zones_zone_id_foreign');
		});
		Schema::table('zones', function(Blueprint $table) {
			$table->dropForeign('zones_country_id_foreign');
		});
		Schema::table('zones', function(Blueprint $table) {
			$table->dropForeign('zones_state_id_foreign');
		});
		Schema::table('tax_groups_taxes', function(Blueprint $table) {
			$table->dropForeign('tax_groups_taxes_tax_group_id_foreign');
		});
		Schema::table('tax_groups_taxes', function(Blueprint $table) {
			$table->dropForeign('tax_groups_taxes_tax_id_foreign');
		});
	}
}