<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PatientReminder extends Model 
{

    protected $table = 'patient_reminders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function appointment()
    {
        return $this->belongsTo('Appointment');
    }

    public function patient()
    {
        return $this->belongsTo('Patient');
    }

    public function supplier()
    {
        return $this->belongsTo('Supplier');
    }

}