<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('site_id')->unsigned()->index();
			$table->time('monday_from_am')->nullable();
			$table->time('monday_to_am')->nullable();
			$table->time('monday_from_pm')->nullable();
			$table->time('monday_to_pm')->nullable();
			$table->time('tuesday_from_am')->nullable();
			$table->time('tuesday_to_am')->nullable();
			$table->time('tuesday_from_pm')->nullable();
			$table->time('tuesday_to_pm')->nullable();
			$table->time('wednesday_from_am')->nullable();
			$table->time('wednesday_to_am')->nullable();
			$table->time('wednesday_from_pm')->nullable();
			$table->time('wednesday_to_pm')->nullable();
			$table->time('thursday_from_am')->nullable();
			$table->time('thursday_to_am')->nullable();
			$table->string('thursday_from_pm');
			$table->time('thursday_to_pm')->nullable();
			$table->time('friday_from_am')->nullable();
			$table->time('friday_to_am')->nullable();
			$table->time('friday_from_pm')->nullable();
			$table->time('friday_to_pm')->nullable();
			$table->time('saturday_from_am')->nullable();
			$table->time('saturday_to_am')->nullable();
			$table->time('saturday_from_pm')->nullable();
			$table->time('saturday_to_pm');
			$table->time('sunday_from_am')->nullable();
			$table->time('sunday_to_am')->nullable();
			$table->time('sunday_from_pm')->nullable();
			$table->time('sunday_to_pm')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('schedules');
	}
}