<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('medical_profiles', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('medical_files', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('medical_profiles', function(Blueprint $table) {
			$table->dropForeign('medical_profiles_patient_id_foreign');
		});
		Schema::table('medical_files', function(Blueprint $table) {
			$table->dropForeign('medical_files_patient_id_foreign');
		});
	}
}