<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitesTable extends Migration {

	public function up()
	{
		Schema::create('invites', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('email', 191);
			$table->string('invite_code', 10);
			$table->timestamps();
			$table->date('expires_at');
			$table->tinyInteger('status');
		});
	}

	public function down()
	{
		Schema::drop('invites');
	}
}