<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function regions()
    {
        return $this->belongsTo('App\Region');
    }

    public function addresses()
    {
        return $this->hasMany('App\Address');
    }

    public function stores()
    {
        return $this->hasOne('App\Store');
    }

    public function points()
    {
        return $this->hasMany('App\Point');
    }

    public function products()
    {
        return $this->belongsTo('App\Favorite');
    }

    public function orders()
    {
        return $this->hasMany('App\Order');
    }

    public function rates()
    {
        return $this->belongsTo('\Product_Rate');
    }

}