<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductRatesTable extends Migration {

	public function up()
	{
		Schema::create('product_rates', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->integer('value');
			$table->string('title', 191);
			$table->text('comment');
			$table->string('image', 191);
		});
	}

	public function down()
	{
		Schema::drop('product_rates');
	}
}