<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImagesTable extends Migration {

	public function up()
	{
		Schema::create('images', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('image_type_id')->unsigned();
			$table->bigInteger('imageable_id');
			$table->string('imageable_type');
			$table->string('original_name');
			$table->string('path');
			$table->integer('size');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('images');
	}
}