<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->bigIncrements('id')->primary();
			$table->bigInteger('service_type_id')->unsigned();
			$table->bigInteger('vendor_id')->unsigned();
			$table->bigInteger('village_id')->unsigned();
			$table->string('name');
			$table->string('address');
			$table->decimal('price', 10,2);
			$table->string('longitude');
			$table->string('latitude');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}