<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Agency extends Eloquent {

	protected $table = 'agencies';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'registered_name', 'rnc', 'email', 'phone', 'address', 'description', 'enable');
	protected $visible = array('email');

	public function reservations()
	{
		return $this->hasMany('Reservation', 'agency_id');
	}

}