<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ReservationPackage extends Model 
{

    protected $table = 'reservation_packages';
    public $timestamps = true;
    protected $fillable = array('inherit_id', 'reservation_id', 'name', 'drinks', 'price', 'pax', 'total', 'pax_name', 'room', 'country_id', 'was_upgrated', 'upgrade_id');

    public function package()
    {
        return $this->belongsTo('Package', 'inherit_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

    public function reservation()
    {
        return $this->belongsTo('Reservation', 'reservation_id');
    }

    public function getUpgrade()
    {
        return $this->hasOne('ReservationPackage', 'upgrade_id');
    }

}