<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('username', 'name', 'last_name', 'email');

	public function role()
	{
		return $this->belongsToMany('Role', 'user_id');
	}

	public function attempts()
	{
		return $this->hasMany('Login_attempts');
	}

}