<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('category_id')->references('category_id')->on('category')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->foreign('brand_id')->references('brand_id')->on('brand')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('customer_id')->references('customer_id')->on('customer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('shipping_id')->references('shipping_id')->on('shipping')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('payment_id')->references('payment_id')->on('payment')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('order_id')->references('order_id')->on('order')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->foreign('product_id')->references('product_id')->on('product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_category_id_foreign');
		});
		Schema::table('product', function(Blueprint $table) {
			$table->dropForeign('product_brand_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_customer_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_shipping_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_payment_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_order_id_foreign');
		});
		Schema::table('order_details', function(Blueprint $table) {
			$table->dropForeign('order_details_product_id_foreign');
		});
	}
}