<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRolesTable extends Migration {

	public function up()
	{
		Schema::create('roles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('admin_id')->unsigned();
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->enum('status', array('0', '1'));
			$table->integer('delete_status');
		});
	}

	public function down()
	{
		Schema::drop('roles');
	}
}