<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersPackagesTable extends Migration {

	public function up()
	{
		Schema::create('users_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('package_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->timestamps();
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->integer('admin_delete');
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('users_packages');
	}
}