<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfitsTimesTable extends Migration {

	public function up()
	{
		Schema::create('profits_times', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('package_id')->unsigned();
			$table->integer('profit_type');
			$table->string('profit');
			$table->timestamps();
			$table->integer('admin_add');
			$table->integer('admin_update');
			$table->enum('delete_status', array('0', '1'));
			$table->enum('admin_delete', array('0', '1'));
			$table->enum('status', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('profits_times');
	}
}