<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBundlesTable extends Migration {

	public function up()
	{
		Schema::create('bundles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('general_notes', 255)->nullable();
			$table->string('lang', 100)->nullable();
			$table->string('message', 255)->nullable();
			$table->string('package', 100)->nullable();
			$table->string('country', 100)->nullable();
			$table->string('options', 255)->nullable();
			$table->float('price')->nullable();
			$table->string('status', 100)->nullable();
			$table->integer('order_id')->nullable();
			$table->datetime('last_updated_at')->nullable();
			$table->string('department', 100)->nullable();
			$table->string('writer_handover', 100)->nullable();
			$table->string('designer_handover', 100)->nullable();
			$table->string('it_handover')->nullable();
			$table->string('character_handover', 100)->nullable();
			$table->integer('number_of_edits')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('bundles');
	}
}