<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('order_id')->unsigned();
			$table->float('total')->nullable();
			$table->enum('type', array('new', 'edit'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}