<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type', 191)->nullable();
			$table->integer('user_id')->unsigned();
			$table->string('manufacturer', 191);
			$table->string('model', 191);
			$table->string('name', 191)->nullable();
			$table->string('year', 11);
			$table->string('color', 191)->nullable();
			$table->string('numbers', 11)->nullable();
			$table->string('letters', 191)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}