<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('patients', function(Blueprint $table) {
			$table->foreign('doctorid')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('doctorid')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('adminid')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('courrier_id')->references('id')->on('courriers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->foreign('lab_id')->references('id')->on('labs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('hospitals', function(Blueprint $table) {
			$table->foreign('doctorid')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('doctorid')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('courrier_id')->references('id')->on('courriers')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('lab_id')->references('id')->on('labs')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('questionid')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('doctorid')->references('id')->on('doctors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('progress', function(Blueprint $table) {
			$table->foreign('test_id')->references('id')->on('tests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('patients', function(Blueprint $table) {
			$table->dropForeign('patients_doctorid_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_patient_id_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_doctorid_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_adminid_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_courrier_id_foreign');
		});
		Schema::table('tests', function(Blueprint $table) {
			$table->dropForeign('tests_lab_id_foreign');
		});
		Schema::table('hospitals', function(Blueprint $table) {
			$table->dropForeign('hospitals_doctorid_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_doctorid_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_patient_id_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_test_id_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_courrier_id_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_lab_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_questionid_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_doctorid_foreign');
		});
		Schema::table('progress', function(Blueprint $table) {
			$table->dropForeign('progress_test_id_foreign');
		});
	}
}