<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('invoice_date', 'payment_method', 'total_bill', 'discount', 'customer_note', 'status', 'customer_id');

    public function items()
    {
        return $this->hasMany('Orderitem', 'order_id');
    }

    public function orderServe()
    {
        return $this->hasOne('OrderNumber', 'order_id');
    }

    public function Customer()
    {
        return $this->belongsTo('Customer', 'order_id');
    }

}