<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('price');
			$table->bigInteger('category_id')->unsigned();
			$table->text('description');
			$table->boolean('availability')->default(1);
			$table->integer('quantity');
			$table->mediumInteger('number_of_purchases')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}