<?php

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('name', 'price', 'category_id', 'description', 'availability', 'quantity', 'number_of_purchases');

	public function category()
	{
		return $this->belongsTo('Category', 'id');
	}

	public function orderItems()
	{
		return $this->hasOne('Orderitem', 'product_id');
	}

	public function images()
	{
		return $this->hasMany('ProImage', 'product_id');
	}

}