<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRollsTable extends Migration {

	public function up()
	{
		Schema::create('Rolls', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('User_id')->unsigned();
			$table->integer('unit_id')->unsigned();
			$table->integer('manufacturing_id')->unsigned();
			$table->string('total');
			$table->string('role_type');
			$table->string('roll_material');
			$table->string('roll_weight');
			$table->string('received_by');
			$table->string('received_at');
			$table->string('purchased_from');
			$table->string('approved_by');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Rolls');
	}
}