<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_langue')->references('id')->on('langue')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('id_categorie')->references('id')->on('categorie')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('texte', function(Blueprint $table) {
			$table->foreign('id_users')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('texte-traduit', function(Blueprint $table) {
			$table->foreign('id_users')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('texte-traduit', function(Blueprint $table) {
			$table->foreign('id_langue')->references('id')->on('langue')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('texte-traduit', function(Blueprint $table) {
			$table->foreign('id_texte')->references('id')->on('texte')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_langue_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_id_categorie_foreign');
		});
		Schema::table('texte', function(Blueprint $table) {
			$table->dropForeign('texte_id_users_foreign');
		});
		Schema::table('texte-traduit', function(Blueprint $table) {
			$table->dropForeign('texte-traduit_id_users_foreign');
		});
		Schema::table('texte-traduit', function(Blueprint $table) {
			$table->dropForeign('texte-traduit_id_langue_foreign');
		});
		Schema::table('texte-traduit', function(Blueprint $table) {
			$table->dropForeign('texte-traduit_id_texte_foreign');
		});
	}
}