<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDealsTable extends Migration {

	public function up()
	{
		Schema::create('deals', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('contact_id')->unsigned()->nullable();
			$table->string('deal_name');
			$table->string('status');
			$table->date('expected_closing_date');
			$table->integer('deal_value');
			$table->string('description');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('deals');
	}
}