<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('parent_id')->index();
			$table->string('name', 200)->index();
			$table->string('slug', 200);
			$table->integer('user_id')->unsigned()->index();
			$table->boolean('is_global')->index();
			$table->json('children')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}