<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerCustomerAddressTable extends Migration {

	public function up()
	{
		Schema::create('mer_customer_address', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->string('adress', 255)->nullable();
			$table->tinyInteger('status')->default('1');
			$table->string('city', 255)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('postal_code', 255)->nullable();
			$table->string('phone1', 255)->nullable();
			$table->string('phone2', 255)->nullable();
			$table->string('lat', 255)->nullable();
			$table->string('long', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 225)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('extra4', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
			$table->tinyInteger('default')->default('0');
			$table->bigInteger('customer_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_customer_address');
	}
}