<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerOrderDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('mer_order_discounts', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_id')->nullable();
			$table->bigInteger('order_item_id')->nullable();
			$table->double('total')->nullable();
			$table->bigInteger('discount_id')->nullable();
			$table->string('code', 255)->nullable();
			$table->string('customer_applies_type', 255)->nullable();
			$table->string('customer_applies_value', 255)->nullable();
			$table->string('item_applies_type', 255)->nullable();
			$table->string('item_applies_value', 255)->nullable();
			$table->string('coupon_code', 255)->nullable();
			$table->bigInteger('coupon_id')->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('extra4', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_order_discounts');
	}
}