<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerOrderItemTable extends Migration {

	public function up()
	{
		Schema::create('mer_order_item', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('order_id')->unsigned()->nullable();
			$table->string('total', 255)->nullable();
			$table->string('weight', 255)->nullable();
			$table->string('quantity', 255)->nullable();
			$table->bigInteger('product_id')->unsigned()->nullable();
			$table->string('code', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('unit_cost', 255)->nullable();
			$table->string('unit_price', 255)->nullable();
			$table->double('is_taxed')->nullable();
			$table->string('image', 255)->nullable();
			$table->text('desv')->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3')->nullable();
			$table->string('extra4', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_order_item');
	}
}