<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerPaymentsTable extends Migration {

	public function up()
	{
		Schema::create('mer_payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('order_id')->nullable();
			$table->tinyInteger('status')->nullable();
			$table->string('process_class_name', 255)->nullable();
			$table->string('card_name', 255);
			$table->string('card_type', 255)->nullable();
			$table->date('card_date')->nullable();
			$table->string('card_number_display', 255)->nullable();
			$table->string('extra1', 255)->nullable();
			$table->string('extra2', 255)->nullable();
			$table->string('extra3', 255)->nullable();
			$table->string('extra4', 255)->nullable();
			$table->text('note')->nullable();
			$table->string('scope', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('mer_payments');
	}
}