<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('middle_name', 255);
			$table->string('last_name', 255);
			$table->string('full_name', 255);
			$table->date('dob');
			$table->string('mobile_no', 30)->unique();
			$table->string('country_code', 10);
			$table->string('patient_category', 100);
			$table->string('country', 100);
			$table->string('state', 100);
			$table->string('city', 100);
			$table->string('area', 200);
			$table->string('address', 500);
			$table->string('email', 200);
			$table->string('passport_number', 100)->nullable();
			$table->integer('age');
			$table->string('gender', 100);
			$table->date('registration_date');
			$table->string('insurance_provider', 100);
			$table->string('insurance_number', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}