<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClinicsTable extends Migration {

	public function up()
	{
		Schema::create('clinics', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('number');
			$table->string('name');
			$table->integer('device_count')->default('4');
			$table->integer('group_id')->nullable();
			$table->date('date_opened')->nullable();
			$table->integer('quickbase_id')->unsigned()->nullable();
			$table->integer('quickbase_company')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clinics');
	}
}